/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.generators.client.model.ModelWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;

@ParametersAreNonnullByDefault
public class RenderWindGenerator
extends MekanismTileEntityRenderer<TileEntityWindGenerator>
implements IWireFrameRenderer {
    private final ModelWindGenerator model;

    public RenderWindGenerator(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelWindGenerator(context.m_173585_());
    }

    protected void render(TileEntityWindGenerator tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        double angle = this.performTranslationsAndGetAngle(tile, partialTick, matrix);
        this.model.render(matrix, renderer, angle, light, overlayLight, false);
        matrix.m_85849_();
    }

    protected String getProfilerSection() {
        return "windGenerator";
    }

    public boolean shouldRenderOffScreen(TileEntityWindGenerator tile) {
        return true;
    }

    public void renderWireFrame(BlockEntity tile, float partialTick, PoseStack matrix, VertexConsumer buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntityWindGenerator) {
            TileEntityWindGenerator windGenerator = (TileEntityWindGenerator)tile;
            double angle = this.performTranslationsAndGetAngle(windGenerator, partialTick, matrix);
            this.model.renderWireFrame(matrix, buffer, angle, red, green, blue, alpha);
            matrix.m_85849_();
        }
    }

    private double performTranslationsAndGetAngle(TileEntityWindGenerator tile, float partialTick, PoseStack matrix) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate((PoseStack)matrix, (Direction)tile.getDirection(), (float)0.0f, (float)180.0f, (float)90.0f, (float)270.0f);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        double angle = tile.getAngle();
        if (tile.getActive()) {
            angle = (tile.getAngle() + (double)(((float)tile.m_58899_().m_123342_() + 4.0f) / 8.0f * partialTick)) % 360.0;
        }
        return angle;
    }
}

